#!/bin/bash
export datasets="Cora CiteSeer PubMed cs physics wikics dblp OGBN-Arxiv"
export missing_rates="0.3"
export embedders="MLP GNN"
export gpu=1

for data in $datasets
do
for missing_rate in $missing_rates
do
python main.py --dataset ${data} --missing_rate ${missing_rate} --embedder MLP --filling_method zero --gpu ${gpu}
python main.py --dataset ${data} --missing_rate ${missing_rate} --embedder PaGNN --gpu ${gpu}
python main.py --dataset ${data} --missing_rate ${missing_rate} --embedder GCNMF --gpu ${gpu}
python main.py --dataset ${data} --missing_rate ${missing_rate} --embedder GNN --gnn GCN --filling_method zero --gpu ${gpu}
python main.py --dataset ${data} --missing_rate ${missing_rate} --embedder GNN --gnn GCN --filling_method neighborhood_mean --gpu ${gpu}
python main.py --dataset ${data} --missing_rate ${missing_rate} --embedder GNN --gnn GCN --filling_method fp --gpu ${gpu}
python main.py --dataset ${data} --missing_rate ${missing_rate} --embedder node2vec_gnn_concat_1 --gnn GCN --gpu ${gpu}
python main.py --dataset ${data} --missing_rate ${missing_rate} --embedder GNN --gnn GCN --filling_method zero --label_trick True --gpu ${gpu}
python main.py --dataset ${data} --missing_rate ${missing_rate} --embedder GNN --gnn GCN --filling_method fp --label_trick True --gpu ${gpu}
python main.py --dataset ${data} --missing_rate ${missing_rate} --embedder Node2Vec_x --gpu ${gpu}
python main.py --dataset ${data} --missing_rate ${missing_rate} --embedder Node2Vec_GNN --gpu ${gpu}
python main.py --dataset ${data} --missing_rate ${missing_rate} --embedder GCN_LPA --filling_method zero --gpu ${gpu}
python main.py --dataset ${data} --missing_rate ${missing_rate} --embedder Correct_Smooth --filling_method zero --gpu ${gpu}
done
done